/*
 * Decompiled with CFR 0.152.
 */
package com.google.api;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public abstract class GoogleAPI {
    protected static final String ENCODING = "UTF-8";
    protected static String referrer;

    public static void setHttpReferrer(String pReferrer) {
        referrer = pReferrer;
    }

    public static void validateReferrer() throws Exception {
        if (referrer == null || referrer.length() == 0) {
            throw new Exception("[google-api-translate-java] Referrer is not set. Call setHttpReferrer().");
        }
    }

    protected static JSONObject retrieveJSON(URL url) throws Exception {
        JSONObject jSONObject;
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("referer", referrer);
        uc.setRequestMethod("GET");
        uc.setDoOutput(true);
        try {
            String result = GoogleAPI.inputStreamToString(uc.getInputStream());
            jSONObject = new JSONObject(result);
        }
        catch (Throwable throwable) {
            try {
                uc.getInputStream().close();
                if (uc.getErrorStream() != null) {
                    uc.getErrorStream().close();
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new Exception("[google-api-translate-java] Error retrieving translation.", ex);
            }
        }
        uc.getInputStream().close();
        if (uc.getErrorStream() != null) {
            uc.getErrorStream().close();
        }
        return jSONObject;
    }

    protected static JSONObject retrieveJSON(URL url, String parameters) throws Exception {
        JSONObject jSONObject;
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("referer", referrer);
        uc.setRequestMethod("POST");
        uc.setDoOutput(true);
        PrintWriter pw = new PrintWriter(uc.getOutputStream());
        pw.write(parameters);
        pw.flush();
        try {
            String result = GoogleAPI.inputStreamToString(uc.getInputStream());
            jSONObject = new JSONObject(result);
        }
        catch (Throwable throwable) {
            try {
                uc.getInputStream().close();
                if (uc.getErrorStream() != null) {
                    uc.getErrorStream().close();
                }
                pw.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new Exception("[google-api-translate-java] Error retrieving translation.", ex);
            }
        }
        uc.getInputStream().close();
        if (uc.getErrorStream() != null) {
            uc.getErrorStream().close();
        }
        pw.close();
        return jSONObject;
    }

    private static String inputStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING));
                while ((string = reader.readLine()) != null) {
                    outputBuilder.append(string).append('\n');
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("[google-api-translate-java] Error reading translation stream.", ex);
        }
        return outputBuilder.toString();
    }
}

